/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapTableCellRenderer;
import filenet.vw.toolkit.design.property.tables.VWSubmapUsageTableModel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class VWSubmapUsageDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener {
    private String m_title = null;
    private VWToolbarBorder m_submapUsageBorder = null;
    private VWTable m_submapUsageTable = null;
    private VWSubmapUsageTableModel m_submapUsageTableModel = null;
    private VWDialogButtons m_dialogButtons = null;
    private GridBagConstraints m_gbCons = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private String m_mapName = null;

    public VWSubmapUsageDialog(Frame parent, VWAuthPropertyData authPropertyData, String mapName) {
        super(parent);
        this.m_authPropertyData = authPropertyData;
        this.m_mapName = VWStringUtils.compare(mapName, VWResource.s_mainMapLabel.toString("Workflow")) == 0 ? "Workflow" : mapName;
        this.m_title = mapName;
    }

    public void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.setTitle(VWResource.s_mapUsage);
        Dimension dim = VWStringUtils.stringToDimension("685,445");
        if (dim != null) {
            this.setSize(dim);
        }
        this.initSubmapTableControl();
        this.initDialogControls();
        this.reinitialize();
    }

    void reinitialize() {
        try {
            if (this.m_submapUsageTableModel != null) {
                this.m_submapUsageTableModel.reinitialize();
            }
            this.m_submapUsageTable.clearSelection();
            this.m_submapUsageTable.setRowSelectionInterval(0, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initSubmapTableControl() {
        JPanel clientPanel = null;
        try {
            this.m_submapUsageBorder = new VWToolbarBorder(this.m_title);
            clientPanel = this.m_submapUsageBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 1;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_submapUsageTableModel = new VWSubmapUsageTableModel(this.m_authPropertyData, this.m_mapName);
            this.m_submapUsageTable = new VWTable(this.m_submapUsageTableModel);
            this.m_submapUsageTable.getSelectionModel().setSelectionMode(0);
            TableColumn tcElement = this.m_submapUsageTable.getColumnModel().getColumn(0);
            if (tcElement != null) {
                tcElement.setCellRenderer(new VWMapTableCellRenderer());
            }
            clientPanel.add((Component)new JScrollPane(this.m_submapUsageTable), gbCons);
            this.m_gbCons.anchor = 23;
            this.m_gbCons.fill = 1;
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 0;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 1.0;
            this.m_gbCons.insets = new Insets(3, 3, 0, 3);
            this.getContentPane().add((Component)this.m_submapUsageBorder, this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initDialogControls() {
        try {
            this.m_gbCons.anchor = 10;
            this.m_gbCons.fill = 0;
            this.m_gbCons.gridx = 0;
            this.m_gbCons.gridy = 3;
            this.m_gbCons.gridheight = 1;
            this.m_gbCons.gridwidth = 1;
            this.m_gbCons.weightx = 1.0;
            this.m_gbCons.weighty = 0.0;
            this.m_gbCons.insets = new Insets(6, 3, 3, 3);
            this.m_dialogButtons = new VWDialogButtons(36);
            this.m_dialogButtons.addDialogButtonsActionListener(this);
            this.getContentPane().add((Component)this.m_dialogButtons, this.m_gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_dialogButtons) {
            int id = event.getID();
            switch (id) {
                case 4: {
                    this.performClose();
                    break;
                }
                case 32: {
                    this.performHelp();
                }
            }
        }
    }

    private void performClose() {
        this.setVisible(false);
    }

    private void performHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh157.htm");
    }
}

